/*
 * ip_resend_wakeup.c -- notify a corresponding ip_resend task about
 *                       changed network interface address.
 *
 * Copyright 2000       by Henner Eisen.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef SOCK_DIR_PREFIX
#define SOCK_DIR_PREFIX "/var/ip_resend"
#endif

#include <unistd.h>
#include <stdio.h>
#include <fcntl.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <limits.h>

static void pr_usage_and_exit_1(void)
{
	fprintf(stderr,
		"usage: ip_resend_wakeup  -m WAKEUP_MESSAGE {-o OUTGOING_INTERFACE | -c PF_UNIX_PATH}\n");
	exit(1);
}


int main(int argc, char **argv)
{
	int ufd, debug=1, c;
	struct sockaddr_un  ua;
	unsigned char *out_dev=NULL, *path=NULL, *msg=NULL, path_buf[PATH_MAX];

	while( (c=getopt(argc,argv,"o:c:m:")) != EOF ){
		switch(c){
		case 'o':
			out_dev = optarg;
			break;
		case 'c':
			path = optarg;
			break;
		case 'm':
			msg = optarg;
			break;
		case 'd':
			debug=atoi(optarg);
			break;
		default:
			pr_usage_and_exit_1();
		}
	}
	
	if(!msg || (!(path || out_dev))) pr_usage_and_exit_1();

	if(! path){
		int n;
		n=snprintf(path_buf,sizeof(path_buf),
			   SOCK_DIR_PREFIX "/%s", out_dev);
		if((n<0) || n>=(sizeof(path_buf)-1)){
			fprintf(stderr, "ip_resend -o %s: option too long!\n");
			return 1;
		}
		path = path_buf;
	}

	if( (ufd=socket(PF_LOCAL,SOCK_DGRAM,0)) < 0){
		perror("error creating PF_LOCAL socket");
		return 1;
	}

	ua.sun_family = AF_LOCAL;
	strncpy(ua.sun_path,path,sizeof(ua.sun_path));

	if(debug > 1) printf("ip_resend_wakeup -c %s: waiting for write\n",
			     path);

	if( sendto(ufd, msg, strlen(msg), 0,
		   (struct sockaddr*) &ua, sizeof(ua)) < 0){
		fprintf(stderr, "ip_resend_wakeup: sendto(%s) error: ",
			path);
		perror("");
		return 1;
	}
	if(debug>0) printf("ip_resend_wakeup -c %s: done\n",path);
	return 0;
}
